import argparse


def _add_arguments_gen(sp: argparse.Namespace) -> None:
    """
    # fugue hub gen -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')
    sp.add_argument('--listen_port',
                    type=str,
                    required=True,
                    dest='listen_port',
                    help='Hub listen port')
    sp.add_argument('--endpoint',
                    type=str,
                    required=True,
                    dest='endpoint',
                    help='Hub endpoint')


def set_subparser(subparsers: argparse.Namespace) -> argparse.Namespace:
    subparser_hub = subparsers.add_parser('hub', help='hub commands.')

    # the subparser had subparsers
    subparser_hub_subparsers = subparser_hub.add_subparsers(help='hub actions', dest='action')

    subparser_hub_gen = subparser_hub_subparsers.add_parser('gen', help='Generate hub.')
    _ = subparser_hub_subparsers.add_parser('show', help='Show existing hubs.')

    _add_arguments_gen(subparser_hub_gen)

    return subparser_hub
