import argparse
import fugue.peer
from typing import List


def _add_arguments_new(sp: argparse.Namespace) -> None:
    """
    # fugue peer new -h
    """
    # required
    sp.add_argument('--public_key',
                    type=str,
                    required=True,
                    dest='public_key',
                    help='Peer public_key')
    sp.add_argument('--allowed_ip',
                    type=str,
                    action='append',
                    required=True,
                    dest='allowed_ips',
                    help='Peer allowed_ips')

    # optional
    sp.add_argument('--name',
                    type=str,
                    required=False,
                    dest='name',
                    help='Peer name')
    sp.add_argument('--endpoint',
                    type=str,
                    required=False,
                    dest='endpoint',
                    help='Peer endpoint')
    sp.add_argument('--persistent_keepalive',
                    type=int,
                    required=False,
                    dest='persistent_keepalive',
                    help='Peer persistent_keepalive')


def _add_arguments_rm(sp: argparse.Namespace, init_peers: List[fugue.peer.Peer]) -> None:
    """
    # fugue peer rm -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    choices=[peer.name for peer in init_peers],
                    dest='name',
                    help='Peer name')


def set_subparser(subparsers: argparse.Namespace, init_peers: List[fugue.peer.Peer]) -> argparse.Namespace:
    subparser_peer = subparsers.add_parser('peer', help='peer commands.')

    # the subparser has subparsers
    subparser_peer_subparsers = subparser_peer.add_subparsers(help='peer actions', dest='action')

    subparser_peer_new = subparser_peer_subparsers.add_parser('new', help='Create new peer.')
    _ = subparser_peer_subparsers.add_parser('show', help='Show existing peers.')
    subparser_peer_rm = subparser_peer_subparsers.add_parser('rm', help='Remove peer.')

    _add_arguments_new(subparser_peer_new)
    # add_argument_show(subparser_peer_new)
    _add_arguments_rm(subparser_peer_rm, init_peers)

    return subparser_peer
