import argparse


def set_subparser(subparsers: argparse.Namespace):
    subparser_config = subparsers.add_parser('config', help='Configuration commands.')

    # the subparser had subparsers
    subparser_config_subparsers = subparser_config.add_subparsers(help='config actions', dest='action')

    _ = subparser_config_subparsers.add_parser('show', help='Show current config.')

    return subparser_config
