import argparse
import fugue.hub
from typing import List


def _add_arguments_gen(sp: argparse.Namespace,
                       init_hubs: List[fugue.hub.Hub]) -> None:
    """
    # fugue spoke gen -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='spoke name')
    sp.add_argument('--hub',
                    type=str,
                    required=True,
                    choices=[hub.name for hub in init_hubs],
                    dest='hub_name',
                    help='spoke hub')


def _add_arguments_show(sp: argparse.Namespace,
                        init_hubs: List[fugue.hub.Hub]) -> None:
    """
    # fugue spoke show -h
    """
    # optional
    sp.add_argument('--hub',
                    type=str,
                    required=False,
                    choices=[hub.name for hub in init_hubs],
                    dest='hub_name',
                    help='spoke hub')


def set_subparser(subparsers: argparse.Namespace, init_hubs: List[fugue.hub.Hub]) -> argparse.Namespace:
    subparser_spoke = subparsers.add_parser('spoke', help='spoke commands.')

    # the subparser had subparsers
    subparser_spoke_subparsers = subparser_spoke.add_subparsers(help='spoke actions', dest='action')

    subparser_spoke_gen = subparser_spoke_subparsers.add_parser('gen', help='Generate spoke.')
    subparser_spoke_show = subparser_spoke_subparsers.add_parser('show', help='Show spokes.')

    _add_arguments_gen(subparser_spoke_gen, init_hubs)
    _add_arguments_show(subparser_spoke_show, init_hubs)

    return subparser_spoke
