import argparse
from typing import List

from fugue.lib import Interface, Peer, Tunnel


def _add_arguments_new(sp: argparse.Namespace,
                       init_interfaces: List[Interface],
                       init_peers: List[Peer]) -> None:
    """
    # fugue tunnel new -h
    """
    # required
    sp.add_argument('-i', '--interface',
                    type=str,
                    required=True,
                    choices=[interface.name for interface in init_interfaces],
                    dest='interface_name',
                    help='Interface to use for tunnel.')
    sp.add_argument('-p', '--peer',
                    type=str,
                    action='append',
                    required=True,
                    choices=[peer.name for peer in init_peers],
                    dest='peer_names',
                    help='Peers to add to tunnel.')


def _add_arguments_rm(sp: argparse.Namespace, init_tunnels: List[Tunnel]) -> None:
    """
    # fugue tunnel rm -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    choices=[tunnel.get_name() for tunnel in init_tunnels],
                    dest='name',
                    help='Peer name')


def _add_arguments_start(sp: argparse.Namespace) -> None:
    """
    # fugue tunnel start -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Tunnel name')


def _add_arguments_stop(sp: argparse.Namespace) -> None:
    """
    # fugue tunnel stop -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Tunnel name')


def set_subparser(subparsers: argparse.Namespace,
                  init_tunnels: List[Tunnel],
                  init_interfaces: List[Interface],
                  init_peers: List[Peer]) -> argparse.Namespace:
    subparser_tunnel = subparsers.add_parser('tunnel', help='tunnel commands.')

    # the subparser had subparsers
    subparser_tunnel_subparsers = subparser_tunnel.add_subparsers(help='tunnel actions', dest='action')

    subparser_tunnel_new = subparser_tunnel_subparsers.add_parser('new', help='Create new tunnel.')
    _ = subparser_tunnel_subparsers.add_parser('show', help='Show existing tunnels.')
    subparser_tunnel_rm = subparser_tunnel_subparsers.add_parser('rm', help='Remove tunnel.')

    _add_arguments_new(subparser_tunnel_new, init_interfaces, init_peers)
    # _add_argument_show(subparser_tunnel_new)
    _add_arguments_rm(subparser_tunnel_rm, init_tunnels)

    subparser_tunnel_start = subparser_tunnel_subparsers.add_parser('start', help='Start tunnel.')
    subparser_tunnel_stop = subparser_tunnel_subparsers.add_parser('stop', help='Stop tunnel.')
    _add_arguments_start(subparser_tunnel_start)
    _add_arguments_stop(subparser_tunnel_stop)

    return subparser_tunnel
