import subprocess
from typing import List


def gen_private_key() -> str:
    private_key_out = subprocess.check_output(["wg", "genkey"])
    private_key = private_key_out.decode().replace('\n', '')
    return private_key


def gen_public_key(private_key: str) -> str:
    public_key_out = subprocess.check_output(["wg", "pubkey"], input=private_key.encode())
    public_key = public_key_out.decode().replace('\n', '')
    return public_key


# From man(wg):
# set <interface> [listen-port <port>] [fwmark <fwmark>] [private-key <file-path>] [peer <base64-public-key> [remove] [preshared-key <file-path>] [endpoint <ip>:<port>] [persistent-keepalive <interval seconds>] [allowed-ips <ip1>/<cidr1>[,<ip2>/<cidr2>]...] ]...  # noqa: E501
def set_peer(tunnel: str, pubkey: str, address: str, persistent_keepalive: str) -> str:
    set_cmd: List[str] = [
        "wg", "set", tunnel, "peer", pubkey, "allowed-ips", address, "persistent-keepalive", persistent_keepalive
    ]
    set_out = subprocess.check_output(set_cmd)
    return set_out.decode().replace('\n', '')


def quick(up_or_down: str, tunnel: str) -> str:
    quick_up_out = subprocess.check_output(["wg-quick", up_or_down, tunnel])
    return quick_up_out.decode()


def status() -> str:
    status_out = subprocess.check_output(["wg"])
    return status_out.decode()
