import argparse


def _add_arguments_gen(sp: argparse.Namespace) -> None:
    """
    # fugue hub gen -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')
    sp.add_argument('--listen_port',
                    type=str,
                    required=True,
                    dest='listen_port',
                    help='Hub listen port')
    sp.add_argument('--endpoint',
                    type=str,
                    required=True,
                    dest='endpoint',
                    help='Hub endpoint')


def _add_arguments_rm(sp: argparse.Namespace) -> None:
    """
    # fugue hub gen -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')


def _add_arguments_start(sp: argparse.Namespace) -> None:
    """
    # fugue hub start -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')


def _add_arguments_stop(sp: argparse.Namespace) -> None:
    """
    # fugue hub stop -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')


def _add_arguments_enable(sp: argparse.Namespace) -> None:
    """
    # fugue hub enable -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')


def _add_arguments_disable(sp: argparse.Namespace) -> None:
    """
    # fugue hub disable -h
    """
    # required
    sp.add_argument('-n', '--name',
                    type=str,
                    required=True,
                    dest='name',
                    help='Hub name')


def set_subparser(subparsers: argparse.Namespace) -> argparse.Namespace:
    subparser_hub = subparsers.add_parser('hub', help='hub commands.')

    # the subparser had subparsers
    subparser_hub_subparsers = subparser_hub.add_subparsers(help='hub actions', dest='action')

    subparser_hub_gen = subparser_hub_subparsers.add_parser('gen', help='Generate hub.')
    subparser_hub_rm = subparser_hub_subparsers.add_parser('rm', help='Remove hub.')
    _ = subparser_hub_subparsers.add_parser('show', help='Show existing hubs.')

    _add_arguments_gen(subparser_hub_gen)
    _add_arguments_rm(subparser_hub_rm)

    subparser_hub_start = subparser_hub_subparsers.add_parser('start', help='Start hub.')
    subparser_hub_stop = subparser_hub_subparsers.add_parser('stop', help='Stop hub.')
    _add_arguments_start(subparser_hub_start)
    _add_arguments_stop(subparser_hub_stop)

    subparser_hub_enable = subparser_hub_subparsers.add_parser('enable', help='Enable hub.')
    subparser_hub_disable = subparser_hub_subparsers.add_parser('disable', help='Disable hub.')
    _add_arguments_enable(subparser_hub_enable)
    _add_arguments_disable(subparser_hub_disable)

    return subparser_hub
