import ipaddress
import urllib.parse
from typing import TypeAlias, TypedDict, Optional, List


URL: TypeAlias = urllib.parse.ParseResult


class InterfaceDict(TypedDict):
    private_key: str
    address: ipaddress.IPv4Network
    listen_port: Optional[int]
    name: Optional[str]
    dns: Optional[List[ipaddress.IPv4Address]]
    table: Optional[str]
    mtu: Optional[int]
    pre_ups: Optional[List[str]]
    post_ups: Optional[List[str]]
    pre_downs: Optional[List[str]]
    post_downs: Optional[List[str]]


class PeerDict(TypedDict):
    public_key: str
    allowed_ips: List[ipaddress.IPv4Network]
    name: Optional[str]
    endpoint: Optional[URL]
    persistent_keepalive: Optional[int]
